/*
 * Decompiled with CFR 0.152.
 */
package com.existingeevee.swparasites.handlers;

import com.existingeevee.swparasites.config.ParasiteSWConfig;
import com.existingeevee.swparasites.init.ParasiteSWProperties;
import com.existingeevee.swparasites.items.IHasSRPEvolutionProgress;
import com.oblivioussp.spartanweaponry.api.IWeaponPropertyContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class DisplayTooltipsHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemTooltip(ItemTooltipEvent e) {
        try {
            String progress;
            String translation;
            ItemStack stack = e.getItemStack();
            if (!stack.func_77973_b().getRegistryName().func_110624_b().equals("swparasites")) {
                return;
            }
            List tooltip = e.getToolTip();
            int indexToInsert = tooltip.isEmpty() ? 0 : 1;
            String key = stack.func_77973_b().func_77658_a() + ".desc";
            if (ParasiteSWConfig.easterEgg) {
                if (Keyboard.isKeyDown((int)31)) {
                    key = "easter_egg.swparasites:sweebozo.desc";
                } else if (Keyboard.isKeyDown((int)45)) {
                    key = "easter_egg.swparasites:ev.desc";
                } else if (Keyboard.isKeyDown((int)38)) {
                    key = "easter_egg.swparasites:light.desc";
                }
            }
            if (I18n.func_94522_b((String)key) && !(translation = I18n.func_74838_a((String)key)).contains("--null")) {
                List<String> toAdd = DisplayTooltipsHandler.smartSplitString(translation, 100000);
                if (tooltip.size() > indexToInsert + 1 && !((String)tooltip.get(indexToInsert + 1)).isEmpty()) {
                    toAdd.add("");
                }
                Collections.reverse(toAdd);
                toAdd.forEach(t -> tooltip.add(indexToInsert, t));
            }
            if ((progress = DisplayTooltipsHandler.getProgress(stack)) != null) {
                tooltip.add(1, "");
                tooltip.add(1, progress);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static List<String> smartSplitString(String toSplit, int max) {
        ArrayList<String> ret = new ArrayList<String>();
        if (toSplit.indexOf("\\n") >= 0) {
            String[] newlined;
            for (String n : newlined = toSplit.split("\\\\n")) {
                ret.addAll(DisplayTooltipsHandler.smartSplitString(n, max));
            }
        } else {
            String temp = "";
            for (String s : toSplit.split(" ")) {
                if (temp.replace("%s%", " ").length() + s.replace("%s%", " ").length() > max) {
                    ret.add(temp.trim().replace("%s%", " "));
                    temp = s + " ";
                    continue;
                }
                temp = temp + s + " ";
            }
            ret.add("" + temp.trim().replace("%s%", " "));
        }
        return ret;
    }

    public static String getProgress(ItemStack stack) {
        NBTTagCompound compound;
        boolean hasHeavy = false;
        if (stack.func_77973_b() instanceof IWeaponPropertyContainer) {
            IWeaponPropertyContainer container = (IWeaponPropertyContainer)stack.func_77973_b();
            hasHeavy = container.getAllWeaponProperties().stream().anyMatch(p -> p == ParasiteSWProperties.HEAVY_1 || p == ParasiteSWProperties.HEAVY_2);
        }
        if ((stack.func_77973_b() instanceof IHasSRPEvolutionProgress || hasHeavy) && stack.func_77973_b().getRegistryName().func_110624_b().equals("swparasites") && (compound = stack.func_77978_p()) != null) {
            return TextFormatting.BLUE + "---> " + compound.func_74762_e("srpkills");
        }
        return null;
    }
}

